% <CustomTools>
%   <Menu>
%    <Submenu name="InnerEarLab">
%      <Submenu name="Synapse">
%        <Item name="XT3d IntensLabelROI" icon="Matlab" tooltip="XT3dIntensLabelROI">
%          <Command>MatlabXT::XT3dIntensLabelROI(%i)</Command>
%        </Item>
%      </Submenu>
%    </Submenu>
%   </Menu>
% </CustomTools>
%
%  Description:
%  XT3dIntensLabelROI

function XT3dIntensLabelROI(aImarisApplicationID)

if isempty(cell2mat(strfind(javaclasspath('-all'), 'ImarisLib.jar'))) mlock; javaaddpath ImarisLib.jar; munlock; end;

global vImarisApplication ImInfo ImarisCell fInfoLSM guiInfo

guiInfo=[]; fInfoLSM=[]; ImInfo.doSingleMode=1; ImInfo.doBatchMode=2;

%addpath('W:\public\Software\Imaris\elifesciences\IO');
%addpath('W:\public\Software\Imaris\elifesciences\XT3dIntensLabelROI');

display(computer); display(version); guiInfo.IsVers=version;

% connect to Imaris interface
if ~isa(aImarisApplicationID, 'Imaris.IApplicationPrxHelper')
  vImarisLib = ImarisLib;
  if ischar(aImarisApplicationID)
    aImarisApplicationID = round(str2double(aImarisApplicationID));
  end
  vImarisApplication = vImarisLib.GetApplication(aImarisApplicationID);
else
  vImarisApplication = aImarisApplicationID;
end

% XTension specific code starts here ------------------------------------------

ImInfo.XLSFile='P:\Imaris\ImarisBatchIntensROI.xlsx';
guiInfo.gui.FrameBatch=uicontrol('Style','frame','Units','normalized','Position',[0.0 0.675 1 0.3]);
ImInfo.gui.openBatchFile=uicontrol('Style', 'pushbutton', 'String', 'BatchFile','Units','normalized','Position', [0.05 0.85 0.15 0.1],'Callback',['XT3dIntensLabelROICallBackBatchFile;']);
ImInfo.gui.doBatchFile=uicontrol('Style', 'pushbutton', 'String', 'calc Batch','Units','normalized','Position', [0.05 0.7 0.15 0.1], 'Callback','XT3dIntensLabelROICalc(2);');
ImInfo.gui.openBatchFileTXT=uicontrol('Style', 'text', 'String',ImInfo.XLSFile, 'FontName', 'Times New Roman', 'FontSize', 10,'Units','normalized','Position', [0.2 0.875 0.7 0.05]);

fInfoLSM.file=char(vImarisApplication.GetCurrentFileName); 
if exist(fInfoLSM.file,'file')
  vImarisApplication.FileOpen(fInfoLSM.file,''); vImarisApplication.GetSurpassCamera().SetOrientationAxisAngle([0,0,1],0); vImarisApplication.GetSurpassCamera().Fit(); XT3dReadImage; 
  guiInfo.gui.FrameSingleBatch=uicontrol('Style','frame','Units','normalized','Position',[0.0 0.0 1 0.625]);
  ImInfo.doFWHM=0;ImInfo.gui.doFWHM=uicontrol('Style','checkbox','visible','off','Value',ImInfo.doFWHM,'String',['doFWHM'],'Units','normalized','Position', [0.1 0.52 0.2 0.07], 'Callback',['XT3dIntensLabelROICallBackCheckbox;']);
  ImInfo.doPerCell=0;ImInfo.gui.doPerCell=uicontrol('Style','checkbox','visible','off','Value',ImInfo.doPerCell,'String',['doPerCell'],'Units','normalized','Position', [0.3 0.52 0.2 0.07], 'Callback',['XT3dIntensLabelROICallBackCheckbox;']);
  ImInfo.doBackground=0;ImInfo.gui.doBackground=uicontrol('Style','checkbox','visible','off','Value',ImInfo.doBackground,'String',['doROIBackGrd'],'Units','normalized','Position', [0.5 0.52 0.2 0.07], 'Callback',['XT3dIntensLabelROICallBackCheckbox;']);
  ImInfo.doNoSynSumROI=0;ImInfo.gui.doNoSynSumROI=uicontrol('Style','checkbox','visible','off','Value',ImInfo.doNoSynSumROI,'String',['doNoSynSumROI'],'Units','normalized','Position', [0.7 0.52 0.25 0.07], 'Callback',['XT3dIntensLabelROICallBackCheckbox;']);
  ImInfo.gui.ROIsizeLabel=['X' 'Y' 'Z']; ImInfo.ROIsize=[3 3 2]; 
  dy=0.05;dx=0.2;
  for ii=1:3
    ImInfo.gui.ROIsizeInfo(ii)=uicontrol('Style','text','String',['+/-ROIsize ' ImInfo.gui.ROIsizeLabel(ii) ],'Units','normalized','Position', [0.3 0.5-(ii*dy) dx dy]);
    ImInfo.gui.ROIsize(ii)=uicontrol('Style', 'edit', 'String', num2str(ImInfo.ROIsize(ii)),'Units','normalized','Position', [0.1 0.5-(ii*dy) 0.2 dy], 'Callback',['XT3dIntensLabelROICallBackROIsize;']);
  end

  ImInfo.HistXmax=0;
  ImInfo.gui.HistXmaxinfo=uicontrol('Style','text','String',['HistXmax'],'Units','normalized','Position', [0.3 0.3 dx dy]);
  ImInfo.gui.HistXmax=uicontrol('Style', 'edit', 'String', num2str(ImInfo.HistXmax),'Units','normalized','Position', [0.1 0.3 dx dy],'Callback',['XT3dIntensLabelROICallBackHistXmax']);

  ImInfo.NrOfHistSteps=10;
  ImInfo.gui.NrOfHistStepsinfo=uicontrol('Style','text','String',['HistSteps'],'Units','normalized','Position', [0.3 0.25 dx dy]);
  ImInfo.gui.NrOfHistSteps=uicontrol('Style', 'edit', 'String', num2str(ImInfo.NrOfHistSteps),'Units','normalized','Position', [0.1 0.25 dx dy],'Callback',['XT3dIntensLabelROICallBackNrOfHistSteps']);

  ImInfo.ROIsizeFWHM=[5 5 3];
  for ii=1:3
    ImInfo.gui.ROIsizeFWHMInfo(ii)=uicontrol('Style','text','visible','off','String',['+/-ROIsizeFWHM ' ImInfo.gui.ROIsizeLabel(ii) ],'Units','normalized','Position', [0.7 0.5-(ii*dy) dx dy]);
    ImInfo.gui.ROIsizeFWHM(ii)=uicontrol('Style', 'edit','visible','off', 'String', num2str(ImInfo.ROIsizeFWHM(ii)),'Units','normalized','Position', [0.5 0.5-(ii*dy) dx dy], 'Callback',['XT3dIntensLabelROICallBackROIsize;']);
  end

  ImInfo.HistXmaxFWHM=0;
  ImInfo.gui.HistXmaxFWHMinfo=uicontrol('Style','text','visible','off','String',['HistXmaxFWHM'],'Units','normalized','Position', [0.7 0.3 dx dy]);
  ImInfo.gui.HistXmaxFWHM=uicontrol('Style', 'edit','visible','off', 'String', num2str(ImInfo.HistXmaxFWHM),'Units','normalized','Position', [0.5 0.3 dx dy],'Callback',['XT3dIntensLabelROICallBackHistXmaxFWHM']);

  ImInfo.NrOfHistStepsFWHM=10;
  ImInfo.gui.NrOfHistStepsFWHMinfo=uicontrol('Style','text','visible','off','String',['HistSteps'],'Units','normalized','Position', [0.7 0.25 dx dy]);
  ImInfo.gui.NrOfHistStepsFWHM=uicontrol('Style', 'edit','visible','off', 'String', num2str(ImInfo.NrOfHistStepsFWHM),'Units','normalized','Position', [0.5 0.25 dx dy],'Callback',['XT3dIntensLabelROICallBackNrOfHistStepsFWHM']);

  ImInfo.MembChan=0;
  list=[]; list{1}=['none']; for iList=1:ImInfo.vNumberOfChannels list{iList+1}=['Chan' num2str(iList)]; end;
  ImInfo.gui.MembChan=uicontrol('Style','Listbox','visible','off','String',list,'Units','normalized','Position',[0.1 0.1 0.2 0.1],'Value',ImInfo.MembChan+1,'Callback',['XT3dIntensLabelROICallBackMembChan']);
  ImInfo.gui.gui.MembChanInfo=uicontrol('Style','text','visible','off','String',['MembraneChan'],'Units','normalized','Position', [0.1 0.2 0.2 0.05]);

  ImInfo.ROImoveR=5;
  ImInfo.gui.ROImoveRinfo=uicontrol('Style','text','visible','off','String',['moveROI |Rpix|'],'Units','normalized','Position', [0.3 0.05 dx dy]);
  ImInfo.gui.ROImoveR=uicontrol('Style', 'edit','visible','off','String', num2str(ImInfo.ROImoveR),'Units','normalized','Position', [0.1 0.05 dx dy],'Callback',['XT3dIntensLabelROICallBackROImoveR']);


  ImInfo.gui.doSingle=uicontrol('Style', 'pushbutton', 'String', 'calc Single','Units','normalized','Position', [0.55 0.05 0.2 0.1], 'Callback','XT3dIntensLabelROICalc(1);');

  XT3dIntensLabelROICallBackCheckbox;
end

ImInfo.gui.Ver=uicontrol('Style', 'text', 'String', '09 2017gh', 'FontName', 'Times New Roman', 'FontSize', 10,'Units','normalized','Position', [0.82 0.02 0.15 0.05], 'DeleteFcn', 'XTObjectManager(-1)');
vWindow=get(ImInfo.gui.Ver,'Parent'); vWindowPosition(1:4)=[250, 50, 500, 300]; set(vWindow, 'Position', vWindowPosition,'name','XT3dIntensLabelROI', 'NumberTitle','off');